unit uDemoRTTI;

interface

type
  KlasaDemoRTTI = class
  private
    FPolePrywatne: string;
    FWłaściwośćPrywatna: string;
    FWłaściwośćIndeksowana: array[0..1] of string;
    procedure MetodaPrywatna;
    procedure UstawWłaściwośćPubliczną(const Wartość: string);
    function PodajWłaściwośćPubliczną(aIndeks: integer): string;
    procedure UstawWłaściwośćIndeksowaną(aIndeks: integer; const Wartość: string);
  protected
    procedure MetodaChroniona;
  public
    PolePubliczne: Double;
    procedure MetodaPubliczna;
    procedure MetodaPublicznaZParametrami(aTekst: string; aLiczba: Extended);
    property WłaściwośćPubliczna: string read FWłaściwośćPrywatna write UstawWłaściwośćPubliczną;
    property WłaściwośćIndeksowana[aIndeks: integer]: string read PodajWłaściwośćPubliczną write UstawWłaściwośćIndeksowaną;
  end;

implementation

function KlasaDemoRTTI.PodajWłaściwośćPubliczną(aIndeks: integer): string;
begin
  Result := FWłaściwośćIndeksowana[aIndeks];
end;

procedure KlasaDemoRTTI.MetodaPrywatna;
begin
  WriteLn('To jest metoda prywatna');
end;

procedure KlasaDemoRTTI.MetodaChroniona;
begin
  WriteLn('To jest metoda chroniona');
end;

procedure KlasaDemoRTTI.MetodaPubliczna;
begin
  WriteLn('To jest metoda publiczna');
end;

procedure KlasaDemoRTTI.MetodaPublicznaZParametrami(aTekst: string; aLiczba: Extended);
begin
  WriteLn('Podałeś argumenty ', aTekst, ' i ', aLiczba);
end;

procedure KlasaDemoRTTI.UstawWłaściwośćIndeksowaną(aIndeks: integer; const Wartość: string);
begin
  FWłaściwośćIndeksowana[aIndeks] := Wartość;
end;

procedure KlasaDemoRTTI.UstawWłaściwośćPubliczną(const Wartość: string);
begin
  FWłaściwośćPrywatna := Wartość;
end;

end.
